﻿<%@ Page Title="TBI Instruments - TBI Survey Summary" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentLastAll.aspx.cs" Inherits="TBI_Instruments_InstrumentSummaryNote" MaintainScrollPositionOnPostback="true"%>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
        Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style15
        {
            width: 1037px;
        }
    </style>
    
    <style type="text/css">
        .breadcrumbInstrument {
            background-color:#6B1424;
            border-bottom:1px solid #000;
            color:#FFF;
            font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant:small-caps;
            font-weight:700;
            letter-spacing:1px;
            margin: 2px 0 2px 0;
            padding:8px 25px 5px 10px;
        }
        .auto-style1 {
            height: 31px;
        }
    </style>
    
    
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>

    <script type="text/javascript">

        function HandleButtons(button) {

            var btnSubmit = document.getElementById("<%=SubmitNoteButton.ClientID%>");
            var btnCancel = document.getElementById("<%=CancelButton.ClientID%>");

            //Disable Submit button to prevent user from clicking it while the form is being processed
            if (btnSubmit != null) {
                btnSubmit.disabled = true;

                //Set Submit button caption to indicate processing if the note was submitted to CPRS
                if (button == "Submit" && btnSubmit.value == "Submit Note") {
                    btnSubmit.value = "Submitting...";
                }
            }

            //Disable Cancel button to prevent user from clicking it while the form is being processed
            if (btnCancel != null) {
                btnCancel.disabled = true;
            }

            return;
        }
        
    </script>
    
    <div class="breadcrumbInstrument">
                <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > All Instruments"></asp:Label> 
            </div>
            <br /> 
            
    <center>        
    <asp:Panel ID="PanelPatient" Width="80%"
                  GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
            <table cellpadding = "5" cellspacing = "5" width = "100%">
                <tr>
                    <td align="left">
                         &nbsp;&nbsp;<asp:Label ID = "LabelForName" runat = "server" Text = "Patient:" AssociatedControlID = "LabelPatient"></asp:Label>       
                        &nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label>
                    </td>
                    <td align="right">
                        <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelSSN" Text = "SSN:"></asp:Label>
                        &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel"></asp:Label>
                    
                    </td>
                </tr>

                <tr>
                    <td colspan="2">
                <rsweb:reportviewer ID="ReportViewer1" runat="server" Font-Names="Verdana" ShowParameterPrompts="false" 
                  Font-Size="8pt" Width="100%" EnableHyperlinks="True" Visible="True" ShowBackButton="True" TabIndex="1">
                   <ServerReport ReportPath="" />
                </rsweb:reportviewer>

                    </td>

                </tr>


            </table>
            </asp:Panel>
    </center>
    <br />           
    <div>
       <center>
          
        <asp:Literal ID = "SurveyNoteHTML" runat = "server" Visible="False"></asp:Literal>
     </center>    
        
    <center>
    <asp:Panel ID = "ErrorPanel" runat = "server" Visible = "false">
        <h2 style = "font-size:large;color:Red" >
            <asp:Literal ID = "SurveyNoteError" runat = "server"></asp:Literal> 
        </h2>
    </asp:Panel>     
    </center>
    </div>
    <br />
    <br />
    <br />
    <div style="width:100%">
    <br />
    <br />
    <center> 
    <asp:Panel ID = "ButtonsPanel" runat = "server">  
        <asp:Button ID = "SubmitNoteButton" runat = "server" 
            OnClientClick="HandleButtons('Submit');"                      
            UseSubmitBehavior = "false"  
            Text = "Submit Note" 
            Width = "130px" OnClick = "SubmitNote_Click" TabIndex="100"/>
        <asp:Button ID = "CancelButton" runat = "server" 
            OnClientClick="HandleButtons('Cancel');"                      
            UseSubmitBehavior = "false" 
            Text = "Cancel" 
            Width = "130px" CssClass = "cancel" />
        <br />
        <br />
        <asp:Label ID="Label8" runat="server" SkinID="DataLabel">
            Please review the content.  If you need to make changes, click the Cancel button and edit the answers. If the content is correct,<br />
            click the Submit Note button.<br /><br />

            Note: Once the note is submitted, it will no longer be editable in this tool and updates will need to be done within CPRS.
        </asp:Label>
        <br />   
   </asp:Panel>  
    </center>
    </div>
</asp:Content> 